<?php

require_once 'includes/dbconn.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $invoice_id = $_POST['invoice_id'];
    $payment_amount = $_POST['payment_amount'];
    $payment_date = $_POST['payment_date'];

    $stmt = $conn->prepare("INSERT INTO payments (client_id, invoice_id, payment_amount, payment_date) VALUES (?, ?, ?, ?)");
    $stmt->bind_param("iids", $client_id, $invoice_id, $payment_amount, $payment_date);

    // Assuming $client_id is available in your context
    // If not, you need to fetch it based on the invoice_id or however your application handles client identification

    if ($stmt->execute()) {
        header("Location: invoices.php");
        exit();
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}

?>
